
<?php $__env->startSection('content'); ?>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Sms</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Sms</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            <?php if(session('success')): ?>
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        Sms
                        <a href="<?php echo e(url('sms/new')); ?>" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Sms</a>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Message</th>
                                <th>Status</th>
                                <th>Date Sent</th>

                            </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <?php
                                 $user = App\Models\User::where('phone', $message->phone)->first();

                                ?>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($message->phone); ?></td>
                                <td><?php echo e($message->message); ?></td>

                                <td>
                                    <?php if($message->status ==0 ): ?>
                                    <span class="badge bg-danger">Failed</span>
                                    <?php else: ?>
                                       <span class="badge bg-success">Sent</span>

                                    <?php endif; ?>
                                </td>
                                 <?php
                                    $inputDateTime = $message->created_at;
                                $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                $daysAgo = $days_;

                                ?>
                                <td><?php echo e($daysAgo); ?></td>


                                <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                <a class="dropdown-item" href="<?php echo e(url('sms/delete', $message->id)); ?>"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\swiftnet\resources\views/admin/sms/index.blade.php ENDPATH**/ ?>