
<?php $__env->startSection('content'); ?>
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Tickets</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Tickets</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
           <?php if(session('success')): ?>
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> <?php echo e(session('success')); ?></div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <section class="section">
                <div class="card">
                    <div class="card-header">
                       My Tickets
                          <a href="<?php echo e(url('tickets/create')); ?>" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Ticket</a>
                    </div>

                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                <th>Subject</th>
                                <th>Message</th>
                                <th>Status</th>
                            

                                <th>Actions</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                            
                               <td><?php echo e($ticket->subject); ?></td>
                                <td><?php echo e($ticket->message); ?></td>
                                <?php if($ticket->status == 1): ?>
                                <td>
                                    <span class="badge bg-success">Success</span>
                                </td>
                                <?php else: ?>

                                <td>
                                    <span class="badge bg-warning">Pending</span>
                                </td>

                                <?php endif; ?>
                                
                                <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                <a class="dropdown-item" href="<?php echo e(url('tickets/view',$ticket->id)); ?>"><i class="fa fa-eye" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         view</a>

                                                    <a class="dropdown-item" href="<?php echo e(url('tickets/edit',$ticket->id)); ?>"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         Edit</a>
                                                          
                                                          <a class="dropdown-item" href="<?php echo e(url('tickets/delete',$ticket->id)); ?>"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i>
                                                         Delete</a>
                                                
                                            </div>
                                        </div>
                                    </div>
                                </td>
                               
                            </tr>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\swiftnet\resources\views/user/tickets/index.blade.php ENDPATH**/ ?>