@extends('layouts.app')
@section('content')

    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
            <div class="container mt-5">
                <div class="d-flex justify-content-between">
                    <div></div>
                    <div class="ms-auto">
                        <style>
                            .border7{
                               border:  1px solid #fff!important
                            }
                        </style>
                       

                        <div class="dropdown">
                        <span class=""
                                id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                aria-haspopup="true" aria-expanded="false">
                             <img class="border7" src="{{url('assets/images/faces/8.jpg')}}" height="50" width="50" style="border-radius: 50px;">
                        </span>
                        <div class="dropdown-menu" style="min-width:150px !important; padding: 7px !important; height: 120px;" aria-labelledby="dropdownMenuButtonSec">

                            <li><a href="{{url('update/profile')}}">
                            <i class="fa fa-edit" aria-hidden="true" style="color:;"></i>

                            <span> Update Profile</span>
                       </a></li>
                            <hr>
                              <li>
                        <a href="{{url('auth/logout')}}" class='sidebar-link'>
                            <i class="fa fa-sign-out" aria-hidden="true" style="color: #d1342c;"></i>

                            <span>Logout</span>
                        </a>
                    </li>
                    <hr>
                              <li></li>

                        </div>
                    </div>

                    </div>
                </div>
            </div>

        </header>

        @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
        @if(Auth::user()->role ==2)

        @php
        $sub = App\Models\Subscription::where('user_id',Auth::user()->id)->where('status',1)->first();
       if($sub)
       {
        $endDate = \Carbon\Carbon::parse($sub->end_date);

        // Calculate the number of days remaining
        $daysRemaining = now()->diffInDays($endDate);

        $pc= App\Models\Package::where('id',$sub->package)->first();
       }

        $wallet = App\Models\Wallet::where('user_id',Auth::user()->id)->first();



        @endphp
            <div class="page-heading">
                <h3>Welcome Back {{Auth::user()->name}}</h3>
            </div>

             @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif

            @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <div class="page-content">
                <section class="row">
                    <div class="col-12 col-lg-12">
                        <div class="row">



                        <div class="row">
                            <div class="col-12 col-xl-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>Account Balance</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">

                                                <div class="">
                                                    <h6 class="mb-0">Ksh {{$wallet->amount}} <span class="btn btn-info btn-sm"  data-bs-toggle="modal" data-bs-target="#topModalCenter">Top Up</span></h6>
                                                </div><br><br>
                                                <div class="d-flex align-items-center">
                                                    <p class="mb-0">Service days remaining</p>
                                                        </p>
                                                </div>
                                                <div class="d-flex align-items-center">
                                                  @if($sub)
                                                    <span class="badge bg-success"> {{$daysRemaining}} days until ({{$sub->end_date}})</span>
                                                    @else
                                                     <span class="badge bg-danger">Subscription Expired</span>
                                                    @endif
                                                </div>
                                                <br><br>
                                                <div class="">
                                                    <p class="">The approximate number of days during which services will be provided based on the amount on the account balance
                                                    </p>
                                                </div>

                                        </div>


                                    </div>
                                </div>
                            </div>


                            <div class="col-12 col-xl-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h4>My Service
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="d-flex align-items-center">
                                                   <table class="table table-striped" id="">
                                                        <thead>
                                                        <tr>
                                                            <th>Service</th>
                                                            <th>Plan</th>
                                                            <th>Status</th>
                                                            <th>Price</th>

                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                            @if($sub)

                                                        <tr>

                                                        <td>Internet</td>
                                                           <td>{{$pc->name}}</td>
                                                           <td>
                                                            @if($online_status == 'online')
                                                            <span class="badge bg-success">{{'online'}}</span></td>
                                                            @endif
                                                             @if($online_status == 'offline')
                                                            <span class="badge bg-danger">{{'offline'}}</span></td>
                                                            @endif

                                                           <td>Ksh {{number_format($pc->price,2)}}</td>

                                                        </tr>
                                                        @endif



                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    </div>
                </section>
                <div class="page-heading">
                    <h3></h3>
                    <hr>
                </div>
                <section class="row">
                    <div class="col-12 col-lg-9">
                        <div class="row">

                            <div class="row">


                            </div>
                        </div>

                    </div>
                </section>
            </div>

            <div class="modal fade" id="topModalCenter" tabindex="-1" role="dialog"
                 aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-dialog-centered modal-dialog-scrollable"
                     role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalCenterTitle">Top your up subscription
                            </h5>
                            <button type="button" class="close" data-bs-dismiss="modal"
                                    aria-label="Close">
                                <i data-feather="x"></i>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="form-group">
                                        <label for="first-name-column">Phone</label>
                                        <input type="text" id="first-name-column" class="form-control @error('phone') is-invalid @enderror"
                                               placeholder="Phone" name="phone" value="{{Auth::user()->phone}}">
                                        @error('phone')
                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="form-group">
                                        <label for="first-name-column">Amount</label>
                                        <input type="text" id="first-name-column" class="form-control @error('amount') is-invalid @enderror"
                                               placeholder="Amount" name="amount" value="">
                                        @error('amount')
                                        <span class="invalid-feedback" role="alert">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                        @enderror
                                    </div>
                                </div>
                                <p>Or go to lipa na mpesa paybill <br>
                                    paybill number: 247247 <br>
                                    account number: 206206
                                </p>

                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-light-secondary"
                                        data-bs-dismiss="modal">
                                    <span class="" style="color: #2f3742">Close</span>
                                </button>
                                <button type="button" class="btn btn-primary ml-1"
                                        data-bs-dismiss="modal">

                                    <span style="color:#fff;">Accept</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

        @endif

        @if(Auth::user()->role == 1)
        <div class="page-heading">
            <h3>Statistics</h3>
        </div>
        <div class="page-content">
            <section class="row">
                <div class="col-12 col-lg-12">
                    <div class="row">
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon purple">
                                                <i class="fa fa-users" aria-hidden="true"></i>

                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">All Users</h6>
                                            <h6 class="font-extrabold mb-0">{{$users}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <a href="{{url('users?status=1')}}">
                                            <div class="stats-icon blue">
                                                <i class="iconly-boldProfile"></i>
                                            </div>
                                        </a>
                                        </div>
                                        
                                        <div class="col-md-8">
                                            <a href="{{url('users?status=1')}}">
                                            <h6 class="text-muted font-semibold">Active Users</h6>
                                            <h6 class="font-extrabold mb-0">{{$totalActiveUsers}}</h6>
                                             </a>
                                        </div>
                                   
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon green">
                                               <i class="fa fa-money" aria-hidden="true"></i>

                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">Total Earnings</h6>
                                            <h6 class="font-extrabold mb-0">Ksh {{$total_earnings}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                          <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon red">
                                               <i class="fa fa-money" aria-hidden="true"></i>

                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">Earnings This Month</h6>
                                            <h6 class="font-extrabold mb-0">Ksh {{$earning_month}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon blue">
                                                <i class="fa fa-users" aria-hidden="true"></i>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">Hotspot Users</h6>
                                            <h6 class="font-extrabold mb-0">{{$totalHotspotUsers}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon green">
                                                <i class="iconly-boldAdd-User"></i>
                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">PPOE Users</h6>
                                            <h6 class="font-extrabold mb-0">{{$totalpppoeUsers}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon red">
                                                <i class="fa fa-wifi" aria-hidden="true"></i>

                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">Online Users</h6>
                                            <h6 class="font-extrabold mb-0">{{$onlineUsers}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-6 col-lg-3 col-md-6">
                            <div class="card">
                                <div class="card-body px-3 py-4-5">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="stats-icon green">
                                                <i class="fa fa-ticket" aria-hidden="true"></i>

                                            </div>
                                        </div>
                                        <div class="col-md-8">
                                            <h6 class="text-muted font-semibold">Open Tickets</h6>
                                            <h6 class="font-extrabold mb-0">{{$open_tickets}}</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                                                        @php
                                        $currentYear = date('Y');
                                    @endphp
                                    <h4>Monthly Earnings Year {{$currentYear}} </h4>
                                </div>
                                <div class="card-body">
                                    <div id="chart"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    @if(Auth::user()->role == 3)
                        <div class="page-heading">
                            <h3>Statistics</h3>
                        </div>
                        <div class="page-content">
                            <section class="row">
                                <div class="col-12 col-lg-12">
                                    <div class="row">




                                        <div class="col-6 col-lg-3 col-md-6">
                                            <div class="card">
                                                <div class="card-body px-3 py-4-5">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="stats-icon green">
                                                                <i class="fa fa-ticket" aria-hidden="true"></i>

                                                            </div>
                                                        </div>
                                                        <div class="col-md-8">
                                                            <h6 class="text-muted font-semibold">Open Tickets</h6>
                                                            <h6 class="font-extrabold mb-0">{{$open_tickets}}</h6>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="card">
                                                <div class="card-header">

                                                    <h4>Open Tickets</h4>
                                                    <a href="{{url('tickets/create')}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                                                        New Ticket</a>
                                                </div>
                                                <div class="card-body">

                                                                        <div class="card-body">
                                                                            <table class="table table-striped" id="table1">
                                                                                <thead>
                                                                                <tr>
                                                                                    <th>User</th>
                                                                                    <th>Region</th>
                                                                                    <th>Location</th>
                                                                                    <th>Subject</th>
                                                                                    <th>Message</th>
                                                                                    <th>Status</th>


                                                                                    <th>Actions</th>
                                                                                </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                @foreach($tickets as $ticket)

                                                                                    <tr>
                                                                                        @php
                                                                                            $user = App\Models\User::where('id',$ticket->user_id)->first();


                                                                                            $region = App\Models\Region::where('id',$user->region)->first();


                                                                                        @endphp
                                                                                        <td>{{$user->name}}</td>
                                                                                        @if($region)
                                                                                            <td>{{$region->name}}</td>
                                                                                        @else
                                                                                            <td>N/A</td>
                                                                                        @endif
                                                                                        <td>{{$user->location}}</td>
                                                                                        <td>{{$ticket->subject}}</td>
                                                                                        <td>{{$ticket->message}}</td>

                                                                                        @if($ticket->status == 1)
                                                                                            <td>
                                                                                                <span class="badge bg-success">Success</span>
                                                                                            </td>
                                                                                        @else

                                                                                            <td>
                                                                                                <span class="badge bg-warning">Pending</span>
                                                                                            </td>

                                                                                        @endif

                                                                                        <td>
                                                                                            <div class="btn-group mb-1">
                                                                                                <div class="dropdown">
                                                                                                    <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                                                                            id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                                                                            aria-haspopup="true" aria-expanded="false">
                                                                                                        Actions
                                                                                                    </button>
                                                                                                    <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                                                                        <a class="dropdown-item" href="{{url('tickets/view',$ticket->id)}}"><i class="fa fa-eye" aria-hidden="true" style="color: #7c8db5;"></i>
                                                                                                            view</a>

                                                                                                        <a class="dropdown-item" href="{{url('tickets/edit',$ticket->id)}}"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                                                                            Edit</a>
                                                                                                        <a class="dropdown-item" href="{{url('tickets/mark/solved',$ticket->id)}}"><i class="fa fa-pencil-square-o" aria-hidden="true" style="color: #7c8db5;"></i>
                                                                                                            Mark Resolved</a>
                                                                                                        <a class="dropdown-item" href="{{url('tickets/delete',$ticket->id)}}"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i>
                                                                                                            Delete</a>

                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </td>

                                                                                    </tr>

                                                                                @endforeach

                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>


                                                        </div>
                                            </div>
                                        </div>
                                    </div>
                    @endif

                    <script>
    fetch('{{route('payments.api')}}')
        .then(response => {
            if (!response.ok) {

                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            
                var options  = {

                    annotations: {
                        position: 'back'
                    },
                    dataLabels: {
                        enabled: false
                    },
                    chart: {
                        toolbar: {
                            show: false,
                        },
                        type: 'line',
                        height: 300
                    },
                    fill: {
                        opacity: 1
                    },
                    plotOptions: {
                    },
                    series: [{
                        name: 'Earnings',
                        type: 'column',
                        data: data.totals
                    }],
                    stroke: {
                        width: [0, 1, 2],
                        curve: 'straight'
                    },
                    colors: ['#57caeb'],

                    xaxis: {
                        categories: data.months,
                        labels: {
                            hideOverlappingLabels: true,
                        },
                    },
                }

                var chart = new ApexCharts(document.querySelector("#chart"), options);
                chart.render();

        })
        .catch(error => {
        });
</script>


@endsection
