@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Ticket</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">View Ticket</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>



        </div>
       <section class="section">
                    <div class="card">
                        <div class="card-header">
                            Tickets Details
                            <a href="{{url('sms/create/ticket',$ticket->user_id)}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                                Send Message
                            </a>
                        </div>
                        <div class="card-header">
                            @php
                            $user = App\Models\User::where('id',$ticket->user_id)->first();
                            @endphp
                            <h4 class="card-title">{{$ticket->message}}</h4>
                            <span>{{$user->location}}</span>
                        </div>
                        <div class="card-body">
                            {!! $ticket->message !!}
                        </div>
                    </div>
                </section>
    </div>
@endsection
