@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Sms</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Sms</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
            @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                        Sms
                        <a href="{{url('sms/new')}}" class="btn btn-primary pull-right"><i class="fa fa-plus" aria-hidden="true"></i>
                            New Sms</a>
                    </div>
                    <div class="card-body">
                        <table class="table table-striped" id="table1">
                            <thead>
                            <tr>
                                <th>Customer</th>
                                <th>Phone</th>
                                <th>Message</th>
                                <th>Status</th>
                                <th>Date Sent</th>

                            </tr>
                            </thead>
                            <tbody>
                                @foreach($messages as $message)
                            <tr>
                                @php
                                 $user = App\Models\User::where('phone', $message->phone)->first();

                                @endphp
                                <td>{{$user->name}}</td>
                                <td>{{$message->phone}}</td>
                                <td>{{$message->message}}</td>

                                <td>
                                    @if($message->status ==0 )
                                    <span class="badge bg-danger">Failed</span>
                                    @else
                                       <span class="badge bg-success">Sent</span>

                                    @endif
                                </td>
                                 @php
                                    $inputDateTime = $message->created_at;
                                $datep = Illuminate\Support\Carbon::parse($inputDateTime);
                                $days_ = $datep->longAbsoluteDiffForHumans(Illuminate\Support\Carbon::now());
                                $daysAgo = $days_;

                                @endphp
                                <td>{{$daysAgo}}</td>


                                <td>
                                    <div class="btn-group mb-1">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary btn-sm dropdown-toggle me-1" type="button"
                                                    id="dropdownMenuButtonSec" data-bs-toggle="dropdown"
                                                    aria-haspopup="true" aria-expanded="false">
                                                Actions
                                            </button>
                                            <div class="dropdown-menu" style="min-width:10px !important;" aria-labelledby="dropdownMenuButtonSec">

                                                <a class="dropdown-item" href="{{url('sms/delete', $message->id)}}"><i class="fa fa-trash" aria-hidden="true" style="color: #7c8db5;"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
