@extends('layouts.app')
@section('content')
    <div id="main">
        <header class="mb-3">
            <a href="#" class="burger-btn d-block d-xl-none">
                <i class="bi bi-justify fs-3"></i>
            </a>
        </header>

        <div class="page-heading">
            <div class="page-title">
                <div class="row">
                    <div class="col-12 col-md-6 order-md-1 order-last">
                        <h3>Filter By Date Profit Report</h3>
                        <p class="text-subtitle text-muted"></p>
                    </div>
                    <div class="col-12 col-md-6 order-md-2 order-first">
                        <nav aria-label="breadcrumb" class="breadcrumb-header float-start float-lg-end">
                            <ol class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{url('dashboard')}}">Dashboard</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Filter By Date Profit Report</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
           @if(session('success'))
                <div class="alert alert-success"><i class="bi bi-check-circle"></i> {{ session('success') }}</div>
            @endif
            @if(session('error'))
                <div class="alert alert-danger"><i class="bi bi-exclamation-triangle"></i>
                    {{ session('error') }}
                </div>
            @endif
            <section class="section">
                <div class="card">
                    <div class="card-header">
                       Filter By Date Profit Report
                       
                    </div>

                    <div class="card-body">
                      <form action="{{url()->current()}}" method="GET">
                        <div class="row m-1">

                          
                            <div class="form-group col-12 col-sm-6 col-md-3 col-lg-3">
                                <label class="input-label" for="exampleFormControlInput1">Select from date</label>
                                <input id="start_date" type="date" name="from" class="form-control" value="{{ $from }}">
                            </div>

                            <div class="form-group col-12 col-sm-6 col-md-3 col-lg-3">
                                <label class="input-label" for="exampleFormControlInput1">Select to date </label>
                                <input id="end_date" type="date" name="to" class="form-control" value="{{ $to }}">
                            </div>


                             <div class="col-12 ">
                                <div class="row d-flex ">
                                    <button class="btn btn-success col-3 mr-1">Filter</button>
                                    <a href="{{url('profit_reports/custom')}}" class="btn btn-danger col-3 mr-1">Reset</a>
                                </div>
                            </div>


                    </div>
                    </form>
                         <table class="table table-bordered" id="table1">

                  <thead>
                  <tr>
                       <th>Total Revenue</th>
                    <th>Total Expenses</th>
                 
                     <th>Profit</th>
                      
                   
                   
                  </tr>
                </thead>
                <tbody>
                  
                  <tr>
                   
                    <td>{{number_format($total_sales, 2)}} Ksh</td>
                   <td>{{number_format($total_expenses, 2)}} Ksh</td>
                   <td>{{number_format($total_profit, 2)}} Ksh</td>
                  
                  </tr>


                  
                
                </tbody>
               
              </table>
                    </div>
                </div>

            </section>
        </div>

@endsection
