<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('mikrotik_user')->nullable();
            $table->string('mikrotik_password')->nullable();
            $table->string('mikrotik_host')->nullable();
            $table->integer('mikrotik_port')->nullable();
            $table->string('mpesa_consumerkey')->nullable();
            $table->string('mpesa_consumersecret')->nullable();
            $table->string('mpesa_passkey')->nullable();
            $table->string('mpesa_shortcode')->nullable();
            $table->string('mpesa_initiator_username')->nullable();
            $table->string('mpesa_initiator_password')->nullable();
            $table->string('sms_username')->nullable();
            $table->string('sms_shortcode')->nullable();
            $table->string('sms_apikey')->nullable();
            $table->string('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}
