<?php

namespace App\Traits;
use PEAR2\Net\RouterOS;
use App\Models\Setting;


trait Common
{
    public function mkClient()
    {
        $setting = Setting::where('status',1)->first();
        return new RouterOS\Client($setting->mikrotik_host,$setting->mikrotik_user,$setting->mikrotik_password,$setting->mikrotik_port);
    }

    public function mkUtil()
    {
        return new RouterOS\Util($this->mkClient());

    }

    public function connect()
    {
        $setting = Setting::where('status',1)->first();
       
        return array(
            'host' => $setting->mikrotik_host,
            'username' => $setting->mikrotik_user,
            'password' => $setting->mikrotik_password,
            'port' => $setting->mikrotik_port
        );

    }
}
