<?php

namespace App\Http\Controllers;

use App\Models\Region;
use Illuminate\Http\Request;
use Auth;

class RegionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function index()
    {
        //
        $regions = Region::orderBy('name','ASC')->get();
        return view('admin.regions.index', compact('regions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('admin.regions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $data =  $request->validate([
            'name' => ['required', 'string', 'max:255','unique:regions']
        ]);
        $ok = Region::create($data);
        $route = URL('/admin/regions');
        if($ok)
        {
            return redirect($route)->with('success','region created successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function show(Region $region)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $region = Region::where('id',$id)->first();
        return view('admin.regions.edit',compact('region'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        //
        $region = Region::where('id', $id)->first();
        $data =  $request->validate([
            'name' => ['required', 'string', 'max:255','unique:regions']
        ]);
        $ok = Region::where('id',$id)->update($data);
        $route = URL('/admin/regions');
        if($ok)
        {
            return redirect($route)->with('success','region update successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Region  $region
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $region = Region::where('id',$id)->first();
        $ok = $region->delete();
        $route = URL('/admin/regions');
        if($ok)
        {
            return redirect($route)->with('success','region deleted successfully');

        }else{
            return redirect($route)->with('error','something went wrong');

        }

    }
}
