<?php

namespace App\Http\Controllers;

use App\Imports\contactsCategoryImport;
use App\Imports\PackagesImport;
use App\Imports\UsersImport;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\UsersExport;

class ExcelImportController extends Controller
{
    //
    public function userView()
    {
        return view('admin.imports.users');

    }



    public function storeUsers(Request $request){

        $ok = Excel::import(new UsersImport(),request()->file('file'));

        if($ok){
            return redirect()->back()->with('success', 'imported successfully');

        }else{

            return redirect()->back()->with('error', 'failed, something went wrong');

        }



    }
    public function packagesView()
    {
        return view('admin.imports.packages');

    }



    public function storePackages(Request $request){

        $ok = Excel::import(new PackagesImport(),request()->file('file'));

        if($ok){
            return redirect()->back()->with('success', 'imported successfully');

        }else{

            return redirect()->back()->with('error', 'failed, something went wrong');

        }

    }


     public function exportUsers()
     {
        $headings = [
            'Name',
            'Email',
            'Phone',
            'Location',
            'Region',
            'Package',
           // 'Status',
        ];

        $users = new UsersExport;

        $data = $users->collection();

        return Excel::download($users, 'users.xlsx', null, $headings, null, false, false);

    }
}
