<?php

namespace App\Console\Commands;

use App\Models\Message;
use App\Models\Subscription;
use App\Models\User;
use Illuminate\Console\Command;
use RouterOS\Client;
use RouterOS\Config;
use RouterOS\Query;

class DisconnectUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'disconnect:user';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Disconnect user once subscription has expired';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $users = Subscription::where('status',1)->whereDate('end_date', '=', Carbon::today()->addDays(0))->get();
            foreach ($users as $user){
                $sm = new Message;
                $message = "You have been disconnected from our network please pay to be reconnected";
                $send = $sm->sendSms($user->username,$message);


                $connect = $this->connect();
                $client = new RouterOS\Client($connect['host'],$connect['username'],$connect['password'],$connect['port']);
                $config = new Config([
                    'host' => $connect['host'] ,
                    'user' => $connect['username'],
                    'pass' => $connect['password'],
                    'port' => $connect['port'],
                ]);
                $client2 = new Client($config);
                try {


                    $query = (new Query('/ppp/secret/print'))
                        ->where('name', $user->username);
                    $response = $client2->q($query)->read();

                    foreach ($response as $res) {
                        $userId = $res['.id'];


                        $editRequest = new RouterOS\Request('/ppp/secret/set');
                        $editRequest->setArgument('.id', $res['.id']);

                        $editRequest->setArgument('disabled', 'yes');


                        $editResponse = $client->sendSync($editRequest);
                        //  dd($editResponse);
                    }


                }catch (\Exception $e)
                {
                    dd($e);
                }

                $user2 = User::where('phone',$user->username)->first();

                User::where('id',$user2->id)->update([
                    'status' => 0
                ]);
                Subscription::where('user_id',$user2->id)->update([
                    'status' => 0
                ]);
            }
        }


}
